function [Y,I_row,I_col] = min2d(X)
%
% [Y,I_row,I_col] = min2d(X)
%
% X      Input 2D array
% Y      The minimum point in the 2D array
% I_row  row index of the minimum
% I_col  column index of the minimum
%
% Finding the minimum in the 2D array
% NaN's are ignored when computing the minimum.
% returns the indices of the minimum value in I_row, I_col
%
% Author: Chunlei Zhang
% University of Dayton
% 02/15/2002

[temp_col,I]=min(X,[],1); %Finding the minimum along the column
[Y,II]=min(temp_col);     %Finding the final minimum in the temp 1d array
I_row=I(II);
I_col=II;